********************************************************************************
* Data pre-cleaning code
********************************************************************************

* Since we use the restricted release of the Add Health dataset, we explain variables 
* that we are using from Add Health and how the variables are prepared in separate files.

* 1. Wave 1 individual data: wave1.dta 
* This has all the AddHealth wave 1 variables (for 20745 students) except for 
* friendship nominations, social interactions, and geographic coordinates.

* 2. Friendship nomination data: net_h.dta
* This data file has 11 variables:
* Student ID (aid), five columns of male friends IDs, and another five columns of 
* female friends IDs.
* We pre-processed it in a way that the variable names for variables 2--11 become 
* v2--v11, while the variable aid still remains to be aid. 

* 3. Social interactions data: social_activities.dta
* This dataset have variables for the social activities questionnaires.
* aid s34* s35* s36* s37* s38* s39* s40* s41* s42* s43* 
* ("*" indicates all the variables start with the same strings)
* We have renamed s34*--s43* (a total of 50 variables) as vv1--vv50

* 4. Geographic coordinates data: geocode.dta
* This dataset has four variables: aid, x_axis, y_axis, and commid

use "wave1.dta", clear

* merge friendship nomination dataset
merge 1:1 aid using "netw_h.dta"
drop _merge

* merge the social interactions dataset
merge 1:1 aid using "social_activities.dta"
drop _merge

* merge the geographic coordinates dataset
merge 1:1 aid using "geo_code.dta"

gen female = (bio_sex==2)
replace female =. if bio_sex== 6 | bio_sex==8

gen black_african = (h1gi6b==1)
replace black_african =. if h1gi6b== 6 | h1gi6b==8 | h1gi6b==9
replace black_african=1 if h1gi8==2

gen student_grade= h1gi20

replace student_grade=. if h1gi20==96 |h1gi20==97 | h1gi20==98 | h1gi20==99

gen grade_eng=-1*(h1ed11-4)+1
replace grade_eng=. if h1ed11>4

gen grade_math=-1*(h1ed12-4)+1
replace grade_math=. if h1ed12>4

gen grade_hist=-1*(h1ed13-4)+1
replace grade_hist=. if h1ed13>4

gen grade_sci=-1*(h1ed14-4)+1
replace grade_sci=. if h1ed14>4

egen av_gpa=rowmean(grade_eng grade_math grade_hist grade_sci)

gen physical_devel = h1mp4

replace physical_devel=. if h1mp4==6 |  h1mp4==8 | h1mp4==9 

replace physical_devel=h1fp6 if h1mp4==7
replace physical_devel=. if h1fp6==6 |  h1fp6==8 | h1fp6==9 

gen religion_practice = h1re3
replace religion_practice=. if h1re3==6 | h1re3==8 | h1re3==9 
replace religion_practice=5 if h1re3==7

gen household1= (h1hr2a== 1 | h1hr2a== 2)
replace household1=. if h1hr2a==6 | h1hr2a==8 | h1hr2a==9

gen household2= (h1hr2b== 1 | h1hr2b== 2)
replace household2=. if h1hr2b==6 | h1hr2b==8 | h1hr2b==9

gen household3= (h1hr2c== 1 | h1hr2c== 2)
replace household3=. if h1hr2c==6 | h1hr2c==8 | h1hr2c==9

gen household4= (h1hr2d== 1 | h1hr2d== 2)
replace household4=. if h1hr2d==6 | h1hr2d==8 | h1hr2d==9

gen household5= (h1hr2e== 1 | h1hr2e== 2)
replace household5=. if h1hr2e==6 | h1hr2e==8 | h1hr2e==9

gen household6= (h1hr2f== 1 | h1hr2f== 2)
replace household6=. if h1hr2f==6 | h1hr2f==8 | h1hr2f==9

gen household7= (h1hr2g== 1 | h1hr2g== 2)
replace household7=. if h1hr2g==6 | h1hr2g==8 | h1hr2g==9

gen household8= (h1hr2h== 1 | h1hr2h== 2)
replace household8=. if h1hr2h==6 | h1hr2h==8 | h1hr2h==9

gen household9= (h1hr2i== 1 | h1hr2i== 2)
replace household9=. if h1hr2i==6 | h1hr2i==8 | h1hr2i==9

gen household10= (h1hr2j== 1 | h1hr2j== 2)
replace household10=. if h1hr2j==6 | h1hr2j==8 | h1hr2j==9

gen household11= (h1hr2k== 1 | h1hr2k== 2)
replace household11=. if h1hr2k==6 | h1hr2k==8 | h1hr2k==9

gen household12= (h1hr2l== 1 | h1hr2l== 2)
replace household12=. if h1hr2l==6 | h1hr2l==8 | h1hr2l==9

gen household13= (h1hr2m== 1 | h1hr2m== 2)
replace household13=. if h1hr2m==6 | h1hr2m==8 | h1hr2m==9

gen household14= (h1hr2n== 1 | h1hr2n== 2)
replace household14=. if h1hr2n==6 | h1hr2n==8 | h1hr2n==9

gen household15= (h1hr2o== 1 | h1hr2o== 2)
replace household15=. if h1hr2o==6 | h1hr2o==8 | h1hr2o==9

gen household16= (h1hr2p== 1 | h1hr2p== 2)
replace household16=. if h1hr2p==6 | h1hr2p==8 | h1hr2p==9

gen household17= (h1hr2q== 1 | h1hr2q== 2)
replace household17=. if h1hr2q==6 | h1hr2q==8 | h1hr2q==9

gen household18= (h1hr2r== 1 | h1hr2r== 2)
replace household18=. if h1hr2r==6 | h1hr2r==8 | h1hr2r==9

gen household19= (h1hr2s== 1 | h1hr2s== 2)
replace household19=. if h1hr2s==6 | h1hr2s==8 | h1hr2s==9

gen household20= (h1hr2t== 1 | h1hr2t== 2)
replace household20=. if h1hr2t==6 | h1hr2t==8 | h1hr2t==9

egen family_size= rowtotal(household1  household2 household3 household4 household5 household6/*
*/  household7  household8  household9  household10  household11  household12  household13  household14  household15 /*
*/ household16 household17 household18 household19 household20)
 
gen parent1= (h1hr3a== 11 | h1hr3a== 12 | h1hr3a== 14 | h1hr3a== 15 | h1hr3a== 17   | h1hr3a== 18)
replace parent1=. if h1hr3a== 96 | h1hr3a==97 | h1hr3a==98  | h1hr3a==99

gen parent2= (h1hr3b== 11 | h1hr3b== 12 | h1hr3b== 14 | h1hr3b== 15 | h1hr3b== 17   | h1hr3b== 18)
replace parent2=. if h1hr3b== 96 | h1hr3b==97 | h1hr3b==98  | h1hr3b==99

gen parent3= (h1hr3c== 11 | h1hr3c== 12 | h1hr3c== 14 | h1hr3c== 15 | h1hr3c== 17   | h1hr3c== 18)
replace parent3=. if h1hr3c== 96 | h1hr3c==97 | h1hr3c==98  | h1hr3c==99

gen parent4= (h1hr3d== 11 | h1hr3d== 12 | h1hr3d== 14 | h1hr3d== 15 | h1hr3d== 17   | h1hr3d== 18)
replace parent4=. if h1hr3d== 96 | h1hr3d==97 | h1hr3d==98  | h1hr3d==99

gen parent5= (h1hr3e== 11 | h1hr3e== 12 | h1hr3e== 14 | h1hr3e== 15 | h1hr3e== 17   | h1hr3e== 18)
replace parent5=. if h1hr3e== 96 | h1hr3e==97 | h1hr3e==98  | h1hr3e==99

gen parent6= (h1hr3f== 11 | h1hr3f== 12 | h1hr3f== 14 | h1hr3f== 15 | h1hr3f== 17   | h1hr3f== 18)
replace parent6=. if h1hr3f== 96 | h1hr3f==97 | h1hr3f==98  | h1hr3f==99

gen parent7= (h1hr3g== 11 | h1hr3g== 12 | h1hr3g== 14 | h1hr3g== 15 | h1hr3g== 17   | h1hr3g== 18)
replace parent7=. if h1hr3g== 96 | h1hr3g==97 | h1hr3g==98  | h1hr3g==99

gen parent8= (h1hr3h== 11 | h1hr3h== 12 | h1hr3h== 14 | h1hr3h== 15 | h1hr3h== 17   | h1hr3h== 18)
replace parent8=. if h1hr3h== 96 | h1hr3h==97 | h1hr3h==98  | h1hr3h==99

gen parent9= (h1hr3i== 11 | h1hr3i== 12 | h1hr3i== 14 | h1hr3i== 15 | h1hr3i== 17   | h1hr3i== 18)
replace parent9=. if h1hr3i== 96 | h1hr3i==97 | h1hr3i==98  | h1hr3i==99

gen parent10= (h1hr3j== 11 | h1hr3j== 12 | h1hr3j== 14 | h1hr3j== 15 | h1hr3j== 17   | h1hr3j== 18)
replace parent10=. if h1hr3j== 96 | h1hr3j==97 | h1hr3j==98  | h1hr3j==99

gen parent11= (h1hr3k== 11 | h1hr3k== 12 | h1hr3k== 14 | h1hr3k== 15 | h1hr3k== 17   | h1hr3k== 18)
replace parent11=. if h1hr3k== 96 | h1hr3k==97 | h1hr3k==98  | h1hr3k==99

gen parent12= (h1hr3l== 11 | h1hr3l== 12 | h1hr3l== 14 | h1hr3l== 15 | h1hr3l== 17   | h1hr3l== 18)
replace parent12=. if h1hr3l== 96 | h1hr3l==97 | h1hr3l==98  | h1hr3l==99

gen parent13= (h1hr3m== 11 | h1hr3m== 12 | h1hr3m== 14 | h1hr3m== 15 | h1hr3m== 17   | h1hr3m== 18)
replace parent13=. if h1hr3m== 96 | h1hr3m==97 | h1hr3m==98  | h1hr3m==99

gen parent14= (h1hr3n== 11 | h1hr3n== 12 | h1hr3n== 14 | h1hr3n== 15 | h1hr3n== 17   | h1hr3n== 18)
replace parent14=. if h1hr3n== 96 | h1hr3n==97 | h1hr3n==98  | h1hr3n==99

gen parent15= (h1hr3o== 11 | h1hr3o== 12 | h1hr3o== 14 | h1hr3o== 15 | h1hr3o== 17   | h1hr3o== 18)
replace parent15=. if h1hr3o== 96 | h1hr3o==97 | h1hr3o==98  | h1hr3o==99

gen parent16= (h1hr3p== 11 | h1hr3p== 12 | h1hr3p== 14 | h1hr3p== 15 | h1hr3p== 17   | h1hr3p== 18)
replace parent16=. if h1hr3p== 96 | h1hr3p==97 | h1hr3p==98  | h1hr3p==99

gen parent17= (h1hr3q== 11 | h1hr3q== 12 | h1hr3q== 14 | h1hr3q== 15 | h1hr3q== 17   | h1hr3q== 18)
replace parent17=. if h1hr3q== 96 | h1hr3q==97 | h1hr3q==98  | h1hr3q==99

gen parent18= (h1hr3r== 11 | h1hr3r== 12 | h1hr3r== 14 | h1hr3r== 15 | h1hr3r== 17   | h1hr3r== 18)
replace parent18=. if h1hr3r== 96 | h1hr3r==97 | h1hr3r==98  | h1hr3r==99

gen parent19= (h1hr3s== 11 | h1hr3s== 12 | h1hr3s== 14 | h1hr3s== 15 | h1hr3s== 17   | h1hr3s== 18)
replace parent19=. if h1hr3s== 96 | h1hr3s==97 | h1hr3s==98  | h1hr3s==99

gen parent20= (h1hr3t== 11 | h1hr3t== 12 | h1hr3t== 14 | h1hr3t== 15 | h1hr3t== 17   | h1hr3t== 18)
replace parent20=. if h1hr3t== 96 | h1hr3t==97 | h1hr3t==98  | h1hr3t==99

egen num_parent= rowtotal(parent1 parent2 parent3 parent4 parent5 parent6 /*
*/parent7  parent8 parent9 parent10 parent11 parent12 parent13 parent14/*
*/ parent15 parent16 parent17 parent18 parent19 parent20)

gen two_parent = (num_parent==2)

gen moth_edu = 0 

replace moth_edu = 1 if h1rm1==10 | h1rm1==11 | h1rm1==12 | h1rm1==96 | h1rm1==98

replace moth_edu = 2 if  h1rm1==1 | h1rm1==2 | h1rm1==3

replace moth_edu = 3 if  h1rm1==4 | h1rm1==5 | h1rm1==6 | h1rm1==7

replace moth_edu = 4 if  h1rm1==8 
replace moth_edu = 5 if  h1rm1==9

replace moth_edu = . if  h1rm1==97  | h1rm1==96 | h1rm1==98

gen fath_edu = 0 

replace fath_edu = 1 if h1rf1==10 | h1rf1==11 | h1rf1==12

replace fath_edu = 2 if  h1rf1==1 | h1rf1==2 | h1rf1==3

replace fath_edu = 3 if  h1rf1==4 | h1rf1==5 | h1rf1==6 | h1rf1==7

replace fath_edu = 4 if  h1rf1==8 
replace fath_edu = 5 if  h1rf1==9

replace fath_edu = . if  h1rf1==97   | h1rf1==96 | h1rf1==98

gen pr_edu = fath_edu
replace pr_edu = moth_edu if fath_edu==.

gen family_income=pa55
replace family_income=0 if pa55==9996
gen family_income_ref=(pa55==9996)
replace family_income=.001 if family_income==0

drop grade_eng grade_math grade_hist grade_sci household1-household20 parent1-num_parent moth_edu fath_edu
drop if female==.
drop if black_african==.
drop if student_grade==.
drop if av_gpa==.
drop if physical_devel==.
drop if religion_practice==.
drop if family_size==.
drop if two_parent==.
drop if pr_edu==.
drop if family_income==.
drop if family_income_ref==.

* x variables
export delimited aid female  black_african student_grade av_gpa physical_devel religion_practice family_size two_parent pr_edu family_income family_income_ref  using "X_data.csv", novarnames replace

egen new_sch_id = group(scid)
* drop if geo-code is missing
drop if _merge==1

* friendship nomination
export delimited aid v2-v11 using "net_h_small.csv", novarnames replace

* social interactions
export delimited aid vv2-vv51 using "social_interaction_raw_small.csv", novarnames replace

* socio-demographic variables and geographic coordinates
export delimited aid female  black_african student_grade av_gpa physical_devel religion_practice family_size two_parent pr_edu family_income family_income_ref x_axis y_axis new_sch_id using "soc_x_variables.csv", novarnames replace

